/*
 * Decompiled with CFR 0.152.
 */
package epri.oadr.httppush;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class OADRSSLSocketFactory
extends SSLSocketFactory {
    private String[] m_cipherSuites;
    private String[] m_protocols;
    private SSLContext m_sslContext;

    public OADRSSLSocketFactory(String keyStoreFile, String keyStorePassword, String trustStoreFile, String trustStorePassword, String cipherSuites, String protocols) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance("jks");
        KeyStore trustStore = KeyStore.getInstance("jks");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        keyStore.load(new FileInputStream(keyStoreFile), keyStorePassword.toCharArray());
        trustStore.load(new FileInputStream(trustStoreFile), trustStorePassword.toCharArray());
        kmf.init(keyStore, keyStorePassword.toCharArray());
        this.m_sslContext = SSLContext.getInstance("SSL");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(trustStore);
        this.m_sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        this.m_cipherSuites = cipherSuites.split(",");
        this.m_protocols = protocols.split(",");
    }

    private Socket prepareSocket(Socket aSocket) {
        SSLSocket socket = (SSLSocket)aSocket;
        socket.setEnabledCipherSuites(this.m_cipherSuites);
        socket.setEnabledProtocols(this.m_protocols);
        return socket;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Socket socket = this.m_sslContext.getSocketFactory().createSocket(s, host, port, autoClose);
        return this.prepareSocket(socket);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.m_cipherSuites;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.m_cipherSuites;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.m_sslContext.getSocketFactory().createSocket(host, port);
        return this.prepareSocket(socket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.m_sslContext.getSocketFactory().createSocket(host, port);
        return this.prepareSocket(socket);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.m_sslContext.getSocketFactory().createSocket(host, port, localHost, localPort);
        return this.prepareSocket(socket);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.m_sslContext.getSocketFactory().createSocket(address, port, localAddress, localPort);
        return this.prepareSocket(socket);
    }
}

