/*
 * Decompiled with CFR 0.152.
 */
package epri.oadr.httppush;

import epri.oadr.httppush.HttpPushException;
import epri.oadr.httppush.OADRSSLSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class HttpPush {
    private OADRSSLSocketFactory m_socketFactory;
    private HttpURLConnection m_connection;
    private boolean m_verifyHostname;

    public HttpPush(OADRSSLSocketFactory socketFactory, boolean verifyHostname) {
        this.m_socketFactory = socketFactory;
        this.m_verifyHostname = verifyHostname;
    }

    public String post(String location, String payload) throws IOException, HttpPushException {
        URL url = new URL(location);
        this.m_connection = (HttpURLConnection)url.openConnection();
        if (location.startsWith("https://")) {
            HttpsURLConnection sslConnection = (HttpsURLConnection)this.m_connection;
            if (!this.m_verifyHostname) {
                sslConnection.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            if (this.m_socketFactory != null) {
                sslConnection.setSSLSocketFactory(this.m_socketFactory);
            }
        }
        this.m_connection.setRequestMethod("POST");
        this.m_connection.setDoOutput(true);
        this.m_connection.setRequestProperty("Content-Type", "application/xml");
        this.m_connection.connect();
        OutputStream outputStream = this.m_connection.getOutputStream();
        outputStream.write(payload.getBytes());
        if (this.m_connection.getResponseCode() != 200) {
            throw new HttpPushException(this.m_connection);
        }
        InputStream inputStream = this.m_connection.getInputStream();
        if (this.m_connection.getContentLength() <= 0) {
            return "";
        }
        byte[] result = new byte[this.m_connection.getContentLength()];
        inputStream.read(result, 0, this.m_connection.getContentLength());
        return new String(result, "UTF-8");
    }

    public HttpURLConnection getConnection() {
        return this.m_connection;
    }
}

