/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.keepalive;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.ping.PingFailedListener;
import org.jivesoftware.smack.ping.packet.Ping;

public class KeepAliveManager {
    private static Map<Connection, KeepAliveManager> instances = new HashMap<Connection, KeepAliveManager>();
    private static volatile ScheduledExecutorService periodicPingExecutorService;
    private Connection connection;
    private long pingInterval = SmackConfiguration.getKeepAliveInterval();
    private Set<PingFailedListener> pingFailedListeners = Collections.synchronizedSet(new HashSet());
    private volatile ScheduledFuture<?> periodicPingTask;
    private volatile long lastSuccessfulContact = -1L;

    public static synchronized KeepAliveManager getInstanceFor(Connection connection) {
        KeepAliveManager pingManager = instances.get(connection);
        if (pingManager == null) {
            pingManager = new KeepAliveManager(connection);
            instances.put(connection, pingManager);
        }
        return pingManager;
    }

    private static synchronized void enableExecutorService() {
        if (periodicPingExecutorService == null) {
            periodicPingExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread pingThread = new Thread(runnable, "Smack Keepalive");
                    pingThread.setDaemon(true);
                    return pingThread;
                }
            });
        }
    }

    private static synchronized void handleDisconnect(Connection con) {
        if (periodicPingExecutorService != null) {
            instances.remove(con);
            if (instances.isEmpty()) {
                periodicPingExecutorService.shutdownNow();
                periodicPingExecutorService = null;
            }
        }
    }

    private KeepAliveManager(Connection connection) {
        this.connection = connection;
        this.init();
        this.handleConnect();
    }

    private void handleConnect() {
        this.connection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                KeepAliveManager.this.lastSuccessfulContact = System.currentTimeMillis();
                KeepAliveManager.this.schedulePingServerTask();
            }
        }, null);
    }

    private void init() {
        this.connection.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionClosed() {
                KeepAliveManager.this.stopPingServerTask();
                KeepAliveManager.handleDisconnect(KeepAliveManager.this.connection);
            }

            @Override
            public void connectionClosedOnError(Exception arg0) {
                KeepAliveManager.this.stopPingServerTask();
                KeepAliveManager.handleDisconnect(KeepAliveManager.this.connection);
            }

            @Override
            public void reconnectionSuccessful() {
                KeepAliveManager.this.handleConnect();
                KeepAliveManager.this.schedulePingServerTask();
            }

            @Override
            public void reconnectingIn(int seconds) {
            }

            @Override
            public void reconnectionFailed(Exception e) {
            }
        });
        instances.put(this.connection, this);
        this.schedulePingServerTask();
    }

    public void setPingInterval(long newPingInterval) {
        if (this.pingInterval == newPingInterval) {
            return;
        }
        if (newPingInterval > 0L) {
            KeepAliveManager.enableExecutorService();
        }
        this.pingInterval = newPingInterval;
        if (this.pingInterval < 0L) {
            this.stopPinging();
        } else {
            this.schedulePingServerTask();
        }
    }

    public void stopPinging() {
        this.pingInterval = -1L;
        this.stopPingServerTask();
    }

    public long getPingInterval() {
        return this.pingInterval;
    }

    public void addPingFailedListener(PingFailedListener listener) {
        this.pingFailedListeners.add(listener);
    }

    public void removePingFailedListener(PingFailedListener listener) {
        this.pingFailedListeners.remove(listener);
    }

    public long getTimeSinceLastContact() {
        if (this.lastSuccessfulContact == -1L) {
            return this.lastSuccessfulContact;
        }
        long delta = System.currentTimeMillis() - this.lastSuccessfulContact;
        return delta < 0L ? 0L : delta;
    }

    private synchronized void schedulePingServerTask() {
        KeepAliveManager.enableExecutorService();
        this.stopPingServerTask();
        if (this.pingInterval > 0L) {
            this.periodicPingTask = periodicPingExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    Ping ping = new Ping();
                    PacketIDFilter responseFilter = new PacketIDFilter(ping.getPacketID());
                    final PacketCollector response = KeepAliveManager.this.pingFailedListeners.isEmpty() ? null : KeepAliveManager.this.connection.createPacketCollector(responseFilter);
                    KeepAliveManager.this.connection.sendPacket(ping);
                    if (response != null) {
                        periodicPingExecutorService.schedule(new Runnable(){

                            @Override
                            public void run() {
                                Packet result = response.nextResult(1L);
                                response.cancel();
                                if (result == null) {
                                    for (PingFailedListener listener : KeepAliveManager.this.pingFailedListeners) {
                                        listener.pingFailed();
                                    }
                                }
                            }
                        }, (long)SmackConfiguration.getPacketReplyTimeout(), TimeUnit.MILLISECONDS);
                    }
                }
            }, this.getPingInterval(), TimeUnit.MILLISECONDS);
        }
    }

    private void stopPingServerTask() {
        if (this.periodicPingTask != null) {
            this.periodicPingTask.cancel(true);
            this.periodicPingTask = null;
        }
    }

    static {
        if (SmackConfiguration.getKeepAliveInterval() > 0) {
            Connection.addConnectionCreationListener(new ConnectionCreationListener(){

                @Override
                public void connectionCreated(Connection connection) {
                    new KeepAliveManager(connection);
                }
            });
        }
    }
}

